<?php
header('Content-Type: application/json');
include 'db_connect.php';

$data = json_decode(file_get_contents("php://input"), true);

if(isset($data['lat']) && isset($data['lng'])) {
    $stmt = $conn->prepare("INSERT INTO damage_reports (lat, lng, details) VALUES (?, ?, ?)");
    $stmt->bind_param("dds", $data['lat'], $data['lng'], $data['details']);
    
    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Report Saved"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Database Error"]);
    }
    $stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "Invalid Data"]);
}
$conn->close();
?>